function makelegend( filename )

mf_settings;

[CFMAP, cfcmap] = imread( baseimagefile ); 

addpath('D:\Matlab\svg')

fid = svgheader( filename, 200, 80 + 40*length( imagevaluesused) );

svglabels( fid, 10, 15,  'Legend:', 'font-size', 12)        

cntr = 1;
for idx = imagevaluesused,
    colourfixedvalue = median( CFMAP( MAP(:) == idx ) ) + 1;    
    
    if strncmpi( legenditems{cntr}, 'slip surface',12 ) | strcmpi( legenditems{cntr}, 'fracture') | strcmpi( legenditems{cntr}, 'deformation band'),
        svgrectangle( fid, 20, 13 + 20*cntr, 30, 2, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'none');
        svglabels( fid, 55, 15 + 20*cntr,  legenditems{cntr}, 'font-size', 10)
    else   
        svgrectangle( fid, 20, 5 + 20*cntr, 30, 15, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'black', 'stroke_width',1 );
        svglabels( fid, 55, 15 + 20*cntr,  legenditems{cntr}, 'font-size', 10)
    end
    
    cntr = cntr + 1;
end

svgrectangle( fid, 20, 13 + 20*cntr, 30, 1, 'fill', '#000000', 'stroke', 'none');
svglabels( fid, 55, 15 + 20*cntr,  'Streamline', 'font-size', 10)


cntr = cntr + 2;

svglabels( fid, 10, 15 + 20*cntr,  'Boundary conditions:', 'font-size', 12)        

cntr = cntr + 1;

svgrectangle( fid, 20, 9 + 20*cntr, 30, 5, 'fill', '#000000', 'stroke', 'none');
svglabels( fid, 55, 15 + 20*cntr,  'Flow', 'font-size', 10)

cntr = cntr + 1;

svgrectangle( fid, 20, 9 + 20*cntr, 30, 5, 'fill', '#808080', 'stroke', 'none');
svglabels( fid, 55, 15 + 20*cntr,  'No flow', 'font-size', 10)

svgfooter(fid)




    